--[[---------------------------------------------------------------------------
	Chocolatier Two Help
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local LedgerLabelFont = { standardFontName, kEighteen, DefaultColor }

local moneyFont = { standardFontName, kThirtyTwo, BlackColor }
local statusFont = { standardFontName, kSixteen, BlackColor }
local badgeWidth = 162
local badgeHeight = 106

local medals = {}
for i,m in ipairs(Simulator._Medals) do
	table.insert(medals, Bitmap { x=m.x,y=m.y, image="image/medal_"..tostring(i) })
end

-- local outline = "#<outline color='000000' size=2>"
local outline = "#"

MakeDialog
{
	name="help_dlg",
	Frame
	{
		x=kCenter,y=kCenter,w=640,h=440,color=DialogColor,

		Bitmap { x=0,y=kMax-237	, image="image/ledger_badge",
			Bitmap { x=158,y=26, image="control/globe_up", },
			Text { x=158,y=21,w=68,h=52, label=outline..GetString("map"), name="to_map_label", flags=kHAlignCenter+kVAlignBottom, font=standardWhiteFont },

			Bitmap { x=75,y=12, image="control/recipe_up" },
			Text { x=75,y=8,w=91,h=52, label=outline..GetString("recipes"), flags=kHAlignCenter+kVAlignBottom, font=standardWhiteFont },
				
			Bitmap { x=16,y=26, image="control/pause_up" },
			Text { x=16+12,y=21,w=68-12,h=52, label=outline..GetString("pause"), flags=kHAlignCenter+kVAlignBottom, font=standardWhiteFont },
			
			AppendStyle{font=statusFont},
			Text { name="money", x=41,y=110,w=badgeWidth,h=bsgFontHeight(moneyFont), font=moneyFont, label="#"..bsgDollars(843722) },
			Text { name="rank", label="rank_3", x=41,y=138,w=badgeWidth,h=18, flags=kVAlignTop + kHAlignCenter, },
			Text { name="date", label="#"..bsgDate(100, 2), x=41,y=156,w=badgeWidth,h=18,flags=kVAlignTop + kHAlignCenter, },
			
			Group(medals),
		},
		Window
		{
			x=5,y=5,w=kMax-5,h=kMax-5,
			HelpTitle(9),
			Bitmap { x=0,y=1, image="image/ledger_badge", scale=32/263},
			AppendStyle { font=helpFont, flags=kVAlignCenter+kHAlignLeft },
			Text { x=0,y=40,w=kMax,h=60, label="help9", flags=kVAlignTop+kHAlignLeft },
			
			Bitmap { x=0,y=90, image="control/btn_messages_up",
				Text { x=54,y=8,w=66,h=20, flags=kVAlignCenter+kHAlignCenter, font=LedgerLabelFont, label="lbl_messages" },
			},
			Text { x=150,y=90,w=kMax,h=40, label="help9_info" },
			
			Bitmap { x=kMax-142,y=150, image="control/btn_inventory_up",
				Text { x=11,y=8,w=75,h=20, flags=kVAlignCenter+kHAlignRight, font=LedgerLabelFont, label="lbl_inventory" },
			},
			Text { x=12,y=150,w=kMax-145-12,h=40, label="help9_inv" },

			Bitmap { x=351,y=220, image="control/btn_factory_up",
				Text { x=15,y=8,w=60,h=20, flags=kVAlignCenter+kHAlignCenter, font=LedgerLabelFont, label="lbl_factory" },
				Text { x=123,y=8,w=63,h=20, flags=kVAlignCenter+kHAlignCenter, font=LedgerLabelFont, label="lbl_status" },
			},
				
			Text { x=265,y=260,w=kMax,h=100, label="help9_factory", flags=kVAlignTop+kHAlignLeft },

			Text { x=230,y=340,w=kMax,h=kMax, label="help9_badge" },
		}
	}
}
